package omero_java;

   import omero.api.RawPixelsStorePrx;
   import omero.api.ServiceInterfacePrx;

   public class Main {

       public static void main(String[] args) throws Exception {
 
           omero.client omero= new omero.client("omero.nbi.bbsrc.ac.uk");
           omero.api.ServiceFactoryPrx sf = omero.createSession("USERNAME", "PASSWORD");

           omero.api.IPixelsPrx pixelsService = sf.getPixelsService();
           omero.api.GatewayPrx gateway = sf.createGateway();
           omero.api.RawPixelsStorePrx rawPixelsStore = sf.createRawPixelsStore();

           omero.model.Pixels pixelsObject = gateway.getPixels(1540); 
           rawPixelsStore.setPixelsId(1540, false);

           long xdim = pixelsObject.getSizeX().getValue();
           long ydim = pixelsObject.getSizeY().getValue();
           long zdim = pixelsObject.getSizeZ().getValue();
           long cdim = pixelsObject.getSizeC().getValue();
           long tdim = pixelsObject.getSizeT().getValue();
 
           double xphysize = pixelsObject.getPhysicalSizeX().getValue();
           double yphysize = pixelsObject.getPhysicalSizeY().getValue();
           double zphysize = pixelsObject.getPhysicalSizeZ().getValue();    

           for(int t=0; t<tdim; t++)
           {
               for(int c=0; c<xdim; c++)
               {
                 for(int z=0; z<zdim; z++)
                 {
                    byte[] pixs = rawPixelsStore.getPlane(z,c,t);

                    for(int x=0; x<xdim; x++)
                    {
                       for(int y=0; y<ydim; y++)
                        {
                           int index2d = (int) (y * xdim + x);
                           System.out.println("Pixel: " + pixs[index2d]);
                        }
                    }
                 }
               }
           }
       }
   }
